
markup.push({

	// -------------------------------------------------
	// MARK: mono enhancer

	MonoEnhancerBlock:
	{
		"+": "BlockTemplate",
		gxTitle: "Mono Enhancer",
		gxPopoverInfo: "MonoEnhancerPopover",
		geNodeClass: "AHMonoEnhancerNode",
		h4PresetsId: "MonoEnhancerPresets",
		gxLibraryDescription: "Enrich mono audio with a stereo sound",
		gxLibraryIcon: "library.mono.enhancer",
		geImporterParams: ["node.importCrossover"],
		gxChildViews:
		{
			crossover: {
				"+": "SliderView.blockFace",
				gxValueKey: "node.crossover",
				gxRangeMin: 0,
				gxRangeMax: 1000,
				axTitle: "CrossOver",
				axFormatter: "HertzFormatter",
			},
			label: {
				"+": "LabelView.foreColorTheme1.size11",
				gxFrameRect: "18,31,83,25",
				gxDefaultValue: "Crossover",
			},
			readout: {
				"+": "LabelView.blockReadout",
				gxFrameRect: "18,66,83,25",
				gxValueKey: "node.crossover",
				gxFormatter: "HertzFormatter"
			}
		}
	},
	
	// MARK: popover

	MonoEnhancerPopover:
	{
		"+": "PopoverTemplate",
		gxTitle: "Mono Enhancer",
		gxCanDrawSubviewsIntoLayer: true,
		gxLayout: [ "H:|-12-[self(284)]-12-|",	// sets popover width
					"V:|-12-[self]-12-|",
					"V:|-41-[group]-8-[presetsGroup]"
		],
		gxChildViews:
		{
			title: "PopoverTitle",
			switch: "PopoverOnOffSwitch",
			presetsGroup: presetsGroup(),
			group: {
				"+": "GroupView",
				gxLayout: [
					"H:|-0-[self]-0-|",
					"H:|-12-[crossover]-12-|",
					"V:|-30-[crossover]-12-[infoText(30)]-16-|",

					"V:[crossoverLabel]-(-1)-[crossover]&alignLeft",
					"V:[crossoverReadout]-(-1)-[crossover]&alignRight",
					
					"H:|-12-[infoIcon(16)]-8-[infoText]-11-|",
					"V:[crossover]-14-[infoIcon]",
				],
				gxChildViews:
				{
					crossover: {
						"+": "SliderView",
						gxValueKey: "node.crossover",
						gxRangeMin: 0,
						gxRangeMax: 1000,
						axTitle: "CrossOver",
						axFormatter: "HertzFormatter",
					},
					crossoverLabel: labelView("Crossover Frequency"),
					crossoverReadout: {
						"+": "ReadoutView",
						gxValueKey: "node.crossover",
						gxFormatter: "HertzFormatter"
					},
					infoIcon: { "+": "InfoIcon" },
					infoText: {
						"+": "DescriptionLabelView",
						gxDefaultValue: "Enrich mono audio with a simulated stereo sound."
					},
				}
			}
		}
	},
		

})
